package jp.mosp.common.part;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import jp.mosp.common.CommonConst;

import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.dto.KintaiCommonDtoInterface;
import jp.mosp.human.dto.MKihonDto;

import jp.mosp.workflow.dao.AttendanceRouteDao;
import jp.mosp.workflow.dao.PmAttendanceDao;
import jp.mosp.workflow.dto.AttendanceRouteDto;
import jp.mosp.workflow.dto.PmAttendanceDto;

/**
 * ΑӏFpPartNX
 * @author yoshida
 *	@version	0.0.6
 */
public class KintaiApprovalPart extends BasePart {

	/**
	 * RXgN^
	 */
	public KintaiApprovalPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public KintaiApprovalPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * ΑӏFp[ge[upDAO擾
	 * @since	0.0.2
	 * @return	ςAttendanceRouteDaoCX^X
	 * @throws Exception
	 */
	public AttendanceRouteDao getAttendanceRouteDao() throws Exception {
		return (AttendanceRouteDao) getPreparedDao(AttendanceRouteDao.class.getCanonicalName());
	}

	/**
	 * ΑӏF[g}X^e[upDAO擾
	 * @since	0.0.2
	 * @return	ςPmAttendanceDaoCX^X
	 * @throws Exception
	 */
	public PmAttendanceDao getPmAttendanceDao() throws Exception {
		return (PmAttendanceDao) getPreparedDao(PmAttendanceDao.class.getCanonicalName());
	}

	/**
	 * oΕ\tO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * \ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isRequest(String snriyuu) {
		return VariousPart.getApprovalStatusCodeArray()[0].equals(snriyuu);
	}

	/**
	 * oΕ\tO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * \ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean isRequest(KintaiCommonDtoInterface dto) throws Exception {
		if (VariousPart.chkExistObject(dto)) {
			return isRequest(dto.getSnRiyuu());
		}
		return false;
	}

	/**
	 * oΕꎟFσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is1stApproved(String snriyuu) {
		return VariousPart.getApprovalStatusCodeArray()[1].equals(snriyuu);
	}

	/**
	 * oΕꎟFσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public static boolean is1stApproved(KintaiCommonDtoInterface dto) throws Exception {
		if (VariousPart.chkExistObject(dto)) {
			return is1stApproved(dto.getSnRiyuu());
		}
		return false;
	}

	/**
	 * oΕꎟ߃tO擾
	 * @since	0.0.4
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * ꎟ߂ȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is1stReturned(String snriyuu) {
		return VariousPart.getApprovalStatusCodeArray()[2].equals(snriyuu);
	}

	/**
	 * oΕꎟ߃tO擾
	 * @since	0.0.4
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * ꎟ߂ȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public static boolean is1stReturned(KintaiCommonDtoInterface dto) throws Exception {
		if (VariousPart.chkExistObject(dto)) {
			return is1stReturned(dto.getSnRiyuu());
		}
		return false;
	}

	/**
	 * oΕ񎟏FσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is2ndApproved(String snriyuu) {
		return VariousPart.getApprovalStatusCodeArray()[3].equals(snriyuu);
	}

	/**
	 * oΕ񎟏FσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public static boolean is2ndApproved(KintaiCommonDtoInterface dto) {
		if (VariousPart.chkExistObject(dto)) {
			return is2ndApproved(dto.getSnRiyuu());
		}
		return false;
	}

	/**
	 * oΕ񎟏FσtO擾
	 * @since	0.0.4
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * 񎟍ߍςȂtrueAłȂꍇfalse
	 * </p>
	 */
	public static boolean is2ndReturned(String snriyuu) {
		return VariousPart.getApprovalStatusCodeArray()[4].equals(snriyuu);
	}

	/**
	 * oΕ񎟏FσtO擾
	 * @since	0.0.4
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * 񎟍ߍςȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public static boolean is2ndReturned(KintaiCommonDtoInterface dto) {
		if (VariousPart.chkExistObject(dto)) {
			return is2ndReturned(dto.getSnRiyuu());
		}
		return false;
	}

	/**
	 * oΕ돳FσtO擾
	 * @param dto		ΏۏoΕDTO
	 * @return
	 * <p>
	 * FςȂtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public static boolean isApproved(KintaiCommonDtoInterface dto) throws Exception {
		if (VariousPart.chkExistObject(dto)) {
			if (is1stApproved(dto) || is2ndApproved(dto)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * p\ΑӏF[gꗗ
	 * @since	0.0.2
	 * @param kcode ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return 󏊑FjbgR[hXg
	 * @throws Exception
	 */
	public String[][] getBelongRouteInfoArray(String kCode, Date targetDate) throws Exception {
		// ̎擾
		/*		
		List<AttendanceRouteDto> listRoute = getAttendanceRouteDao().findForAvailable(
				kcode,
				DatePart.convDateFormattedByHyphen(calculate().getStartDate(targetDate))
		);
		 */
		List<AttendanceRouteDto> listRoute = getAttendanceRouteList(kCode, targetDate);
		String[][] aryRoute = new String[listRoute.size()][5];
		for (int i = 0; i < aryRoute.length; i++) {
			aryRoute[i][0] = listRoute.get(i).getSCode();
			aryRoute[i][1] = listRoute.get(i).getKCode();
			aryRoute[i][2] = listRoute.get(i).getLayer1();
			aryRoute[i][3] = listRoute.get(i).getLastLayer();
			aryRoute[i][4] = listRoute.get(i).getJCode();
		}
		return aryRoute;
	}

	/**
	 * p\ΑӏF[gꗗ
	 * @since	0.0.2
	 * @param kcode ΏێЈR[h
	 * @param targetDate	Ώ۔N
	 * @return 󏊑FjbgR[hXg
	 * <p>
	 * [0]cꎟF[gR[h
	 * [1]c񎟏F[gR[h
	 * </p>
	 * @throws Exception
	 */
	public String[] getTargetRouteInfo(String kcode, Date targetDate) throws Exception {
		String[] aryRoute = new String[2];
		aryRoute[0] = "";
		aryRoute[1] = "";
		// ΑӏF[g擾
		String[][] aryRouteInfo = getBelongRouteInfoArray(
				human().getBasisInfoOfUser().getKCode(),
				targetDate
		);
		// ͈͎擾
		int startDate = DatePart.convDateToInteger(calculate().getStartDate(targetDate));
		// ΏێҎЈR[h
		String targetKCode = "";
		HumanBasisDtoInterface targetDto = human().getMKihonDao().findForApprovalKCode(
				kcode,
				human().getBasisInfoOfUser().getJCode(),
				user.getDataLevel(),
				startDate
		);
		if (VariousPart.chkExistObject(targetDto)) {
			targetKCode = targetDto.getKCode();
		} 
		for (int i = 0; i < aryRouteInfo.length; i++) {
			// ΏێЈR[h
			if (aryRouteInfo[i][1].equals(targetKCode)) {
				aryRoute[0] = aryRouteInfo[i][2];
				aryRoute[1] = aryRouteInfo[i][3];
				break;
			}
			// I猟
			else if (aryRouteInfo[i][0].equals(section().getBelongSectionCode(targetKCode))) {
				aryRoute[0] = aryRouteInfo[i][2];
				aryRoute[1] = aryRouteInfo[i][3];
				break;		
			}
		}
		return aryRoute;
	}

	/**
	 * FRz擾
	 * @since	0.0.3
	 * @return	FRz
	 * @throws Exception
	 */
	public String[][] getApprovalReasonArray() throws Exception {
		// FR
		return mospcode().getMosPCodeArray(CommonConst.TID_APPROVAL_REASON);
	}

	/**
	 * FR\
	 * @since	0.0.3
	 * @param riyuu FR
	 * @return	result
	 * @throws Exception 
	 */
	public String[] getApproval(String riyuu) throws Exception {
		String[][] aryApprovalReason = getApprovalReasonArray();
		String[] result = new String[2];
		for (int k = 0; k < aryApprovalReason.length; k++) {
			if (KintaiApprovalPart.isRequest(riyuu)) {
				// \̏ꍇiꎟc\A񎟁c󗓁j
				result[0] = aryApprovalReason[0][1];
				result[1] = "";
			} else if (KintaiApprovalPart.is1stApproved(riyuu)) {
				// ꎟFς̏ꍇiꎟcFρA񎟐\j
				result[0] = aryApprovalReason[1][1];
				result[1] = aryApprovalReason[0][1];
			} else if (riyuu.equals(CommonConst.NUM_ATTENDANCE_1ST_RETURNED)) {
				// ꎟ߂̏ꍇiꎟc߁A񎟁c󗓁j
				result[0] = aryApprovalReason[2][1];
				result[1] = "";
			} else if (KintaiApprovalPart.is2ndApproved(riyuu)) {
				// 񎟏Fς̏ꍇiꎟcFρA񎟏Fρj
				result[0] = aryApprovalReason[1][1];
				result[1] = aryApprovalReason[3][1];
			} else if (riyuu.equals(CommonConst.NUM_ATTENDANCE_2ND_RETURNED)) {
				// ꎟ߂̏ꍇiꎟc񎟍߁A񎟁c󗓁j
				result[0] = aryApprovalReason[4][1];
				result[1] = "";
			} else {
				result[0] = "";
				result[1] = "";
			}
		}
		return result;
	}

	/**
	 * ΑӏF󋵖̎擾
	 * @since	0.0.3
	 * @param snRiyuu		ΑӏF󋵃R[h
	 * @return				ΑӏF󋵖
	 * @throws Exception
	 */
	public String getApprovalName(String snRiyuu) throws Exception {
		return StringPart.getCodeName(snRiyuu, getApprovalReasonArray());
	}

	/**
	 * ΑӏF󋵖̎擾
	 * @since	0.0.3
	 * @param dto		ΏDTO
	 * @return			ΑӏF󋵖
	 * @throws Exception
	 */
	public String getApprovalName(KintaiCommonDtoInterface dto) throws Exception {
		return getApprovalName(dto.getSnRiyuu());
	}

	/**
	 * FΏێ҈ꗗ
	 * @since	0.0.4
	 * @param targetDate
	 * @return
	 * @throws MospException
	 * @throws Exception
	 */
	public List<MKihonDto> getApprovalEmployeeList(String kCode, Date targetDate) throws MospException, Exception {
		// ̐ݒ
		List<MKihonDto> listEmployee = new ArrayList<MKihonDto>();
		List<AttendanceRouteDto> listRoute = getAttendanceRouteList(kCode, targetDate);
		Set<String> employeeKCodeSet = new HashSet<String>();
		for (AttendanceRouteDto dto : listRoute) {
			// ΏۏЈꗗ
			List<MKihonDto> selectSectionUserList = human().getMKihonDao().findForApproval(
					dto.getSCode(),
					office().getBelongOfficeCode(kCode),
					kCode,
					mospuser().getUserInfoForKCode(kCode).getDataLevel(),
					DatePart.convDateToInteger(calculate().getStartDate(targetDate))
			);
			for (MKihonDto mKihonDto : selectSectionUserList) {
				employeeKCodeSet.add(mKihonDto.getKCode());
			}
			// ǉЈ
			MKihonDto addMKihonDto = human().getBasisInfo(dto.getKCode());
			if (VariousPart.chkExistDto(addMKihonDto)) {
				employeeKCodeSet.add(addMKihonDto.getKCode());
			}
		}
		// Јꗗ֒ǉ
		for (String employeeKCode : employeeKCodeSet) {
			listEmployee.add(human().getBasisInfo(employeeKCode));
		}
		return listEmployee;
	}

	/**
	 * ΏۋΑӏF[gꗗXg擾
	 * @since	0.0.5
	 * @param kCode			ΏۏFҎЈR[h
	 * @param targetDate	Ώ۔N
	 * @return list (DTOList)
	 * @throws MospException
	 * @throws Exception
	 */
	public List<AttendanceRouteDto> getAttendanceRouteList(
			String kCode,
			Date targetDate
	) throws MospException, Exception {
		return getAttendanceRouteDao().findForApproval(
				kCode,
				section().getBelongSectionCode(kCode),
				office().getBelongOfficeCode(kCode),
				DatePart.convDateFormattedByHyphen(calculate().getStartDate(targetDate))
		);
	}

	/**
	 * ΏێЈΑӏF[gR[h擾
	 * @since	0.0.5
	 * @param kCode		ΏێЈR[h
	 * @return	ΑӏF[gR[h
	 * @throws Exception
	 */
	public String getRequestRouteCode(String kCode) throws Exception {
		PmAttendanceDto dto = getPmAttendanceDao().findForKCode(kCode);
		if (!VariousPart.chkExistDto(dto)) {
			dto = getPmAttendanceDao().findForRequest(
					section().getBelongSectionCode(kCode),
					office().getBelongOfficeCode(kCode)
			);
		}
		if (VariousPart.chkExistDto(dto)) {
			return dto.getRtCode();
		}
		return null;
	}

	/**
	 * ΑӏF[Nt[F󋵃R[h擾
	 * @since	0.0.6
	 * @param snriyuu	ΏۋΑӏFR[h
	 * @return
	 */
	public static String[] toWorkflowStatus(String snriyuu) {
		String number = "";
		String status = "";
		if (isRequest(snriyuu)) {
			number = String.valueOf(CommonConst.NUM_REQUEST_LAYER);
			status = WorkflowPart.getStatusCodeArray()[0];
		}
		if (is1stApproved(snriyuu)) {
			number = String.valueOf(CommonConst.NUM_LAYER1);
			status = WorkflowPart.getStatusCodeArray()[1];
		}
		if (is1stReturned(snriyuu)) {
			number = String.valueOf(CommonConst.NUM_LAYER1);
			status = WorkflowPart.getStatusCodeArray()[2];
		}
		if (is2ndApproved(snriyuu)) {
			number = String.valueOf(CommonConst.NUM_LAST_LAYER);
			status = WorkflowPart.getStatusCodeArray()[1];
		}
		if (is2ndReturned(snriyuu)) {
			number = String.valueOf(CommonConst.NUM_LAST_LAYER);
			status = WorkflowPart.getStatusCodeArray()[2];
		}
		return new String[]{ number, status };
	}

}
